VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "EchoGramClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Enum EchoGramActions
  egaNone
  egaChangeType
  egaClearGram
  egaClearBox
  egaCopy
  egaDistribution
  egaExtractEchoes
  egaOptions
  egaPrint
  egaZoom
  egaSpace1
  egaSpace2
  egaSpace3
End Enum

Public Event ContextMenuRequest(ByVal X As Long, ByVal Y As Long)
Public Event DimensionChange(ByVal rangeMin As Single, _
                             ByVal rangeMax As Single, _
                             ByVal nPointsX As Long, _
                             ByVal changingType As Boolean, _
                             ByVal changeToClass As Boolean)
Public Event KeyDown(KeyCode As Integer, Shift As Integer)
Public Event StatusBar(ByVal statusText As String)

Private Const rangeTick0 As Long = 72 ' tick size in twips
Private Const rangeLabelGap0 As Long = 24 ' distance between label and tick (twips)
Private Const timeTick0 As Long = 72 ' tick size in twips
Private Const timeLabelGap0 As Long = 24 ' distance between label and tick (twips)

Private Type AxisT
  nPoints As Integer
  min As Double
  max As Double
End Type

Public Enum EchogramType
  egtEnergy
  egtClass
End Enum

Public Enum EchogramSourceType
  estRealtime
  estDatabase
End Enum

Private Enum MouseEventType
  MouseUp
  MouseDown
  MouseMove
  Cancel
End Enum

Private Type LabelType
  coordinate As Double
  label As String
End Type

Private Type SelectBoxType
  x0 As Single
  x1 As Single
  y0 As Single
  y1 As Single
  color As Long
  active As Boolean
  controllerState As Integer
End Type

Private mBox As SelectBoxType             ' Current select box
Private mClassifier As ClassifierClass
Private mColormap As ColorMapClass     ' Gram's color map
Private mCurrentColumn As Integer      ' Column index of most current ping
Private mCursorInfoDisplay As Boolean  ' True if cursor info displayed as tooltip
Private mEchogramSource As EchogramSourceType  ' Where the data comes from
Private mEchogramType As EchogramType      ' How the gram is colorized
Private mEchoPaneX0 As Long             ' Leftmost pixel of echo pane
Private mEchoPaneX1 As Long             ' Rightmost pixel of echo pane
Private mEchoPaneY0 As Long             ' Topmost pixel of echo pane
Private mEchoPaneY1 As Long             ' Bottommost pixel of echo pane
Private mFirstColumn As Integer         ' First column containing pings
Private mFirstRow As Integer            ' First row containing data
Private mFocusColor As Long
Private mGridLines As Boolean           ' True if drawing grid lines
Private mHaveFocus As Boolean
Private mLeftMargin As Long        ' Used by time axis
Private mMenu As Scripting.Dictionary
Private mName As String
Private mNColumns As Integer       ' Current number of columns in use
Private mNPointsX As Integer             ' Number of plot points in x direction
Private mNPointsY As Integer             ' Number of plot points in y direction
Private mOldPictureHeight As Long
Private mOldPictureWidth As Long
Private WithEvents mPicture As PictureBox            ' Place to Draw
Attribute mPicture.VB_VarHelpID = -1
Private mPingLatitudes() As Double       ' Holds latitude of the ping in this column
Private mPingLongitudes() As Double      ' Holds longitude of the ping in this column
Private mPingMax As Long                 ' Used in db style plots
Private mPingMin As Long                 ' Used in db style plots
Private mPingNumbers() As Long           ' Holds number of ping for each column
Private mPingSeriesID As String          ' Holds ping series id for the gram
Private mPingTimes() As Date             ' Holds time of the ping in this column
Private mPingValid() As Boolean          ' True if this ping is extractable
Private mPixelSizeX As Integer      ' >= 1
Private mPixelSizeY As Integer      ' >= 1
Private mPreviousMinute As Integer       ' Used by time axis
Private mPreviousPositionEnd As Long     ' Used by time axis
Private mPropertyPrefix As String        ' Used to retrieve echogram properties
Private mRangeAxisInterval(0 To 8) As Single ' Table used to configure range axes
Private mRangeFactor As Single            ' spacing of bins in meters
Private mRangeMax As Single              ' Max range of the gram
Private mRangeMin As Single               ' min range of the gram
Private mRangeLabelGap As Long ' distance between label and tick (pixels)
Private mRangeLabels() As LabelType       ' Labels for the range axis
Private mRangeTick As Long  ' tick size in pixels
Private mRangeUnit As RangeUnits
Private mRangeUnitAbbrev As String
Private mRangeUnitFromMeters As Single
Private mRangeUnitName As String
Private mTimeTick As Long ' tick size in pixels
Private mTimeLabelGap As Long ' distance between label and tick (pixels)
Private mScrollOneColumn As Boolean
Private mStatusBarDisplay As Boolean      ' if true, then display cursor info in status bar
Private mUseLatLon As Boolean              ' true if lat/lon is to be display on top axis
Private mUseRangeGrid As Boolean
Private mUseRangeLabels As Boolean
Private mUseTimeGrid As Boolean
Private mUseTimeLabels As Boolean
Private mZValues() As Double              ' the pixel values

Private mShowTracks As Boolean              ' REB flag indicating if track should be drawn  - REB 2002.08.08

Private mPrefix As String                   ' DB stuff

Private Const NO_PARENT As Integer = -1002

Private Sub AddMenuItem(ByVal caption As String, _
                        ByVal tag As Integer, _
                        Optional ByVal checked As Boolean = False, _
                        Optional ByVal enabled As Boolean = True, _
                        Optional ByVal visible As Boolean = True)
                        
  Dim item As Scripting.Dictionary
  Set item = New Scripting.Dictionary
  item.Add "caption", caption
  item.Add "tag", tag
  item.Add "checked", checked
  item.Add "enabled", enabled
  item.Add "visible", visible
  mMenu.Add CStr(tag), item
                        
End Sub

Public Sub changeRangeUnits(ByVal units As RangeUnits)

  ConfigureRangeUnits units
  RangeAxisLayout
  PaintGram

End Sub

Private Sub changeType()

  Dim text As String
  text = mName & " is currently displaying "
  text = text & IIf(mEchogramType = egtClass, "classes", "energy") & "."
  text = text & vbCrLf & vbCrLf & "Change gram so it displays "
  text = text & IIf(mEchogramType = egtClass, "energy", "classes") & "?"
  
  Dim reply As Integer
  reply = MsgBox(text, vbYesNo + vbQuestion, "Change Echogram Type")
  If reply = vbYes Then
    ClearGram
    Me.SetupEchoGram mPropertyPrefix, mEchogramSource, _
      IIf(mEchogramType = egtClass, egtEnergy, egtClass), mName, mPicture, _
      mPixelSizeX, mPixelSizeY, mRangeMin, mRangeMax, mPingMin, mPingMax, _
      scrollOneColumn:=mScrollOneColumn
    Me.LayoutGram
    RaiseEvent DimensionChange(mRangeMin, mRangeMax, mNPointsX, True, mEchogramType = egtClass)
  End If

End Sub

Public Sub ClearBox()

  Dim oldDrawMode As Integer
  Dim oldDrawStyle As Integer
  Dim oldFillStyle As Integer

  If mBox.active Then
            
    oldDrawMode = mPicture.DrawMode
    oldDrawStyle = mPicture.DrawStyle
    oldFillStyle = mPicture.FillStyle
    mPicture.DrawStyle = vbSolid
    mPicture.DrawMode = vbXorPen
    mPicture.FillStyle = vbFSTransparent
    mPicture.Line (mBox.x0, mBox.y0)-(mBox.x1, mBox.y1), mBox.color, B
    mPicture.DrawMode = oldDrawMode
    mPicture.DrawStyle = oldDrawStyle
    mPicture.FillStyle = oldFillStyle

    mBox.active = False
    
  End If

End Sub

Public Sub ClearGram()

  ClearBox ' No data, so no selection box
  
  mNColumns = 0
  mCurrentColumn = -1
  mFirstColumn = 0
  mPreviousMinute = -1
  mPreviousPositionEnd = mEchoPaneX0
  
  RaiseEvent DimensionChange(mRangeMin, mRangeMax, mNPointsX, False, False)
  PaintGram
  
End Sub

Public Sub Clear()

  ClearBox ' No data, so no selection box
  
  mNColumns = 0
  mCurrentColumn = -1
  mFirstColumn = 0
  mPreviousMinute = -1
  mPreviousPositionEnd = mEchoPaneX0
  
  PaintGram
  
End Sub

Private Function ColumnToX(ByVal column As Integer) As Integer

  Dim X As Double
  
  If column >= mFirstColumn Then
    X = column - mFirstColumn
  Else
    X = mNPointsX - mFirstColumn + column - 1
  End If

  ColumnToX = X * mPixelSizeX + mEchoPaneX0
  
End Function

Private Sub ConfigureRangeUnits(ByVal units As RangeUnits)

  Select Case units
  
    Case ruFathoms
      mRangeUnitAbbrev = "fm"
      mRangeUnitFromMeters = 1 / 0.3048 / 6
      mRangeUnitName = "fathoms"
      
    Case ruFeet
      mRangeUnitAbbrev = "ft"
      mRangeUnitFromMeters = 1 / 0.3048
      mRangeUnitName = "feet"
    
    Case ruMeters
      mRangeUnitAbbrev = "m"
      mRangeUnitFromMeters = 1
      mRangeUnitName = "meters"
      
    Case Else
      Debug.Assert False
  
  End Select
  
  mRangeUnit = units

End Sub

Private Function ConvertFromPixel(ByVal X As Single, ByVal Y As Single, _
                             row As Long, column As Long) As Boolean
  Dim xPoint As Long
  Dim yPoint As Long
  
  ConvertFromPixel = False
  xPoint = (X - mEchoPaneX0) / mPixelSizeX
  If xPoint >= mNColumns Then
    xPoint = mNColumns - 1
    ConvertFromPixel = True
  End If
  column = xPoint + mFirstColumn
  If column >= mNPointsX Then column = column - mNPointsX
  
  ' JG - Recover on validation check rather than crash with array bounds violation
  If column < 0 Then column = 0
  yPoint = (Y - mEchoPaneY0) / mPixelSizeY
  row = yPoint + mFirstRow
  If row >= mNPointsY Then row = mNPointsY - 1
  ' JG - Recover on validation check rather than crash with array bounds violation
   If row < 0 Then row = 0 ' JG
 
End Function

Private Function ConvertFromPixelBox(box As SelectBoxType, _
                                pingMin As Long, _
                                pingMax As Long, _
                                rangeMin As Single, _
                                rangeMax As Single) As Boolean

  Dim column1 As Long
  Dim column2 As Long
  Dim i As Long
  Dim row1 As Long
  Dim row2 As Long
  
  ConvertFromPixelBox = False   ' REB 2002.08.20 tracker
  
  ConvertFromPixel box.x0, box.y0, row1, column1
  ConvertFromPixel box.x1, box.y1, row2, column2
  If Not mPingValid(column1) Then
    i = column1
    Do
      i = Modulus(i + 1, mNPointsX)
      If mPingValid(i) Then Exit Do
    Loop While (i <> column2 And i <> column1)
    MsgBox ("A portion of the select box contains invalid data." & vbCrLf & _
           "Invalid portions will be ignored." & vbCrLf & _
             (IIf(mShowTracks, vbCrLf & "(Tracks will only be displayed if the entire selected area " & vbCrLf & "is valid and from the most current ping series)", ""))) _
           , vbInformation, "Ignoring Part of Selection" _

           
    ConvertFromPixelBox = True    ' true iff. the selected area contained invalid/old data - REB 2002.08.20 tracker
  Else
    i = column1
  End If
  
  pingMin = mPingNumbers(i)
  rangeMin = RowToRange(row1)
  pingMax = mPingNumbers(column2)
  rangeMax = RowToRange(row2)
  

End Function

Public Sub CopyToClipboard()

  Clipboard.Clear
  Clipboard.SetData mPicture.Image

End Sub

Public Sub CursorTooltipEnable(ByVal enable As Boolean)

  mCursorInfoDisplay = enable

End Sub

Private Function DisplayGramInfo(ByVal X As Single, ByVal Y As Single) As String

  ' Displays information about the pixel under the cursor using
  ' the status bar and/or the tooltip.
  
  Dim column As Long
  Dim pingNumber As Long
  Dim positionLabel As String
  Dim raiseIt As Boolean
  Dim range As Single
  Dim row As Long
  Dim theTime As Date
  Dim ts As Single
  Dim xPoint As Long
  Dim yPoint As Long
  
  On Error GoTo oops
  
  raiseIt = True
  xPoint = (X - mEchoPaneX0) / mPixelSizeX
  If Not InRange(mEchoPaneX0, X, mEchoPaneX1) Or _
     Not InRange(mEchoPaneY0, Y, mEchoPaneY1) Then
    raiseIt = False
    If X > mEchoPaneX1 And Y < mEchoPaneY1 Then
      DisplayGramInfo = mName & ":: range in " & mRangeUnitName
    Else
      DisplayGramInfo = mName & "::" & IIf(mEchogramType = egtClass, "classes", "energy") & IIf(mColormap.GetName() = "_StandardClass", "; * No colormap *", "")
    End If
  Else
    ' Find the column in the data array
    If mNColumns = 0 Then Exit Function
    Dim columnCapped As Boolean
    columnCapped = ConvertFromPixel(X, Y, row, column)
    If columnCapped Or Not mPingValid(column) Then
      DisplayGramInfo = ""
      positionLabel = ""
      raiseIt = False
    Else
      theTime = mPingTimes(column)
      pingNumber = mPingNumbers(column)
      range = RowToRange(row) * mRangeUnitFromMeters
      ts = mZValues(row, column)
      If mUseLatLon Then
        positionLabel = "; p= " & LatLonDoubleToString(mPingLatitudes(column), True) & " " & _
                        LatLonDoubleToString(mPingLongitudes(column), False)
      Else
        positionLabel = ""
      End If
      If mEchogramType = egtEnergy Then
        DisplayGramInfo = _
          "r=" & Format(range, "###0.00 ") & mRangeUnitAbbrev & "; " & _
          "ts=" & IIf(ts < -1000 Or ts > 1000, " n/a", Format(ts, "###0.0")) & " dB; " & _
          "t=" & Format(theTime, "h:Nn:Ss") & "; " & _
          "#=" & pingNumber
      Else
        If general.sonarIF.GetClassifier() Is Nothing Then
          DisplayGramInfo = _
            "r=" & Format(range, "###0.00") & mRangeUnitAbbrev & "; " & _
            "?=noClassifier; " & _
            "t=" & Format(theTime, "h:Nn:Ss") & "; " & _
            "#=" & pingNumber
        Else
          Dim classifier As ClassifierClass
          Set classifier = general.sonarIF.GetClassifier
          DisplayGramInfo = _
            "r=" & Format(range, "###0.00") & mRangeUnitAbbrev & "; " & _
            "?=" & IIf(ts > classNoEcho And ts <= classifier.GetNExplicitClasses, classifier.GetClassName(ts), "*") & "; " & _
            "t=" & Format(theTime, "h:Nn:Ss") & "; " & _
            "#=" & pingNumber
        End If
      End If
    End If
  End If
  
  If mCursorInfoDisplay Then mPicture.ToolTipText = DisplayGramInfo
  If raiseIt Then RaiseEvent StatusBar(DisplayGramInfo & positionLabel)
  
  Exit Function
  
oops:

  Debug.Assert (False) ' trying to catch pesky overflow error
  Rethrow "DisplayGramInfo"
      
End Function

Public Sub distributionPlot()

  Debug.Assert (mBox.active)
  
  Dim column0 As Long
  Dim column1 As Long
  Dim nPointsX As Long
  Dim nPointsY As Long
  Dim ping0 As Long
  Dim ping1 As Long
  Dim range0 As Single
  Dim range1 As Single
  Dim row0 As Long
  Dim row1 As Long
  
  '  The the coordinates of the box
  
  ConvertFromPixelBox mBox, ping0, ping1, range0, range1
  nPointsX = ping1 - ping0 + 1
  nPointsY = (row1 - row0 + 1)
  nPointsY = (mNPointsY \ nPointsY) * nPointsY
  
  Dim distributionPlot As frmDistributionPlot
  Set distributionPlot = New frmDistributionPlot
  distributionPlot.Left = (mBox.x1 + mPicture.Left) * Screen.TwipsPerPixelX + mPicture.parent.Left + 108
  distributionPlot.FormSetup range0, range1, ping0, ping1, _
                             mEchogramType, mColormap
  distributionPlot.Show

End Sub

Public Sub FormatGram()
  
  Dim changed As Boolean
  Dim useGrid As Boolean
  
  useGrid = mUseRangeGrid Or mUseTimeGrid
  
  frmColorMap.mnuAssociate.enabled = IIf(mEchogramType = egtClass, True, False) 'DFL KB#29
  
  changed = frmEchogramFormat.GetResults(mRangeMin, mRangeMax, mPixelSizeX, _
                                         mPixelSizeY, useGrid, mUseLatLon, mColormap, _
                                         mName, mRangeUnit)
  
  If changed Then

    With general.propertyList
      .SetProperty mPropertyPrefix & ":pixelSizeX", mPixelSizeX
      .SetProperty mPropertyPrefix & ":pixelSizeY", mPixelSizeY
      .SetProperty mPropertyPrefix & ":rangemin", mRangeMin
      .SetProperty mPropertyPrefix & ":rangemax", mRangeMax
      .SetProperty mPropertyPrefix & ":useGrid", useGrid
      .SetProperty mPropertyPrefix & ":useLatLon", mUseLatLon
      ConfigureRangeUnits mRangeUnit
    End With
    
    mUseRangeGrid = useGrid
    mUseTimeGrid = useGrid
  
    LayoutGram
  End If

End Sub

Public Sub GramPrint()
  
'  Me.MousePointer = vbHourglass
  Printer.Orientation = vbPRORLandscape
  Printer.PaintPicture mPicture.Image, 0, 0, _
                       Printer.ScaleWidth, Printer.ScaleHeight
  Printer.Line (0, 0)-(Printer.ScaleWidth, Printer.ScaleHeight), vbBlack, B
  Printer.EndDoc
'  Me.MousePointer = vbDefault

End Sub

Private Function GetValue(ByVal value As Variant, ByVal key As String, _
                          ByVal default As String) As String
                     
  If Not IsMissing(value) Then
    GetValue = value
  Else
    GetValue = general.propertyList.GetProperty(key, default)
  End If

End Function

Private Function getEmptyValue() As Single

  getEmptyValue = IIf(mEchogramType = egtClass, classNoEcho, -10000000000#)
  
End Function

Public Function GetMenu() As Scripting.Dictionary

  mMenu.item(CStr(egaZoom)).item("enabled") = mBox.active
  mMenu.item(CStr(egaDistribution)).item("enabled") = mBox.active
  mMenu.item(CStr(egaExtractEchoes)).item("enabled") = True
  mMenu.item(CStr(egaClearBox)).item("enabled") = mBox.active
  
  Set GetMenu = mMenu

End Function

Private Function GetTimeAxisHeight()

  GetTimeAxisHeight = _
    mPicture.TextHeight("0123456789") + mTimeTick + mTimeLabelGap + 3
      ' 3 = one for axis line + two to leave blank pixels below label

End Function

Private Function FindAColormap(mColormapName As String) As ColorMapClass

  Dim themColormap As ColorMapClass
  Set themColormap = New ColorMapClass

  On Error GoTo noMap
  If mColormapName <> "" Then
  
    '   If a color map was specified, try to load it.
  
    themColormap.ReadFromDB mColormapName, general.parametersDb
    
  Else
  
    '  Otherwise, try to get one from an intelligent default
  
    If mEchogramType = egtClass Then
    
      '  For class grams, try to get one from the classifier.
    
      If Not general.classifier Is Nothing Then
      
        mColormapName = general.classifier.GetColorMapName()
        
        If Trim(mColormapName) <> "" Then
          themColormap.ReadFromDB mColormapName, general.parametersDb
        End If
      End If
    Else
    
      '  For energy grams, use the system default
    
      themColormap.ReadFromDB "_StandardEnergy", general.parametersDb
    End If
  End If
  
  Dim OK As Boolean
  
  If mEchogramType = egtClass And themColormap.IsValid() And _
     Not general.classifier Is Nothing Then
    OK = False
    On Error GoTo associationFailure
    themColormap.SetClassifier general.classifier
    OK = True
    On Error GoTo 0
    
associationFailure:

    If Not OK Then
      themColormap.ReadFromDB "_StandardClass", general.parametersDb
    End If
    
  End If
  
  Set FindAColormap = themColormap
  
  Exit Function

noMap:

  Set FindAColormap = Nothing

End Function

Public Sub LayoutGram()

  Debug.Assert (Not mPicture Is Nothing)
  
  '  Divide up the pixels in the gram between the axes and
  '  the echo portion of the display.  Do the Y direction first.
  
  mPicture.Cls
  
  Dim oldNPointsX As Long
  Dim oldNPointsY As Long
  
  mEchoPaneY0 = mPicture.TextHeight("X") + 4
  mEchoPaneY1 = mPicture.ScaleHeight - GetTimeAxisHeight()
  oldNPointsY = mNPointsY
  mNPointsY = (mEchoPaneY1 - mEchoPaneY0 + 1) \ mPixelSizeY
  
  RangeAxisLayout
  oldNPointsX = mNPointsX
  mNPointsX = (mEchoPaneX1 - mEchoPaneX0 + 1) \ mPixelSizeX
    
  If mEchoPaneY1 <= mEchoPaneY0 Or mEchoPaneX1 <= mEchoPaneX0 Then Exit Sub
  
  '  Adjust the data arrays

  Dim newZValues() As Double
  Dim newPingNumbers() As Long
  Dim newPingTimes() As Date
  Dim newPingLatitudes() As Double
  Dim newPingLongitudes() As Double
  Dim newPingValid() As Boolean
  
  ReDim newZValues(0 To mNPointsY - 1, 0 To mNPointsX - 1) As Double
  ReDim newPingNumbers(0 To mNPointsX - 1) As Long
  ReDim newPingTimes(0 To mNPointsX - 1) As Date
  ReDim newPingLatitudes(0 To mNPointsX - 1) As Double
  ReDim newPingLongitudes(0 To mNPointsX - 1) As Double
  ReDim newPingValid(0 To mNPointsX - 1) As Boolean
  
  '  Copy over the old data
  
  Dim nColumnsToCopy As Long
  Dim nRowsToCopy As Long
  nColumnsToCopy = minl(mNPointsX, mNColumns)   ' minl returns the smaller a
  nRowsToCopy = minl(mNPointsY, oldNPointsY)
  
  Dim column As Long
  Dim i As Long
  Dim j As Long
  
  For i = 0 To nColumnsToCopy - 1
    column = Modulus(mFirstColumn + i, oldNPointsX)
    newPingNumbers(i) = mPingNumbers(column)
    newPingTimes(i) = mPingTimes(column)
    newPingLatitudes(i) = mPingLatitudes(column)
    newPingLongitudes(i) = mPingLongitudes(column)
    newPingValid(i) = mPingValid(column)
    For j = 0 To nRowsToCopy - 1
      newZValues(j, i) = mZValues(j, column)
    Next j
    For j = nRowsToCopy To mNPointsY - 1
      newZValues(j, i) = getEmptyValue()
    Next j
  Next i
  
  ' Install the new arrays
  
  mZValues = newZValues
  mPingNumbers = newPingNumbers
  mPingTimes = newPingTimes
  mPingLatitudes = newPingLatitudes
  mPingLongitudes = newPingLongitudes
  mPingValid = newPingValid
  
  ' Adjust the parameters
  
  mFirstColumn = 0
  mCurrentColumn = nColumnsToCopy - 1
  SetRangeFactor
  mPreviousMinute = -1
  mLeftMargin = 0
   
  RaiseEvent DimensionChange(mRangeMin, mRangeMax, mNPointsX, False, False)

  If mEchogramSource = estDatabase Then LoadDataFromDatabase
  
  PaintGram

End Sub

Private Sub RangeAxisLayout()

  '  Determine what the separation between ticks will be on
  '  the range axis.  Start with the lowest separation in the
  '  intervals tables, and keep increasing it until a separation
  '  of at least a 1/4 inch results.
  
  Dim deltaRange As Single
  Dim i As Long
  Dim maxDivisions As Long
  Dim nDivisions As Long
 
  maxDivisions = Int((mEchoPaneY1 - mEchoPaneY0) * Screen.TwipsPerPixelY / (0.25 * 1440)) + 1
  deltaRange = (mRangeMax - mRangeMin) * mRangeUnitFromMeters
  i = -1
  Do
    i = i + 1
    nDivisions = deltaRange / mRangeAxisInterval(i)
  Loop Until nDivisions <= maxDivisions Or i = UBound(mRangeAxisInterval)
  
  ' Round down the first tick range so that it falls on an even
  ' boundary.
  
  Dim axisInterval As Single
  Dim firstTickRange As Single
  
  axisInterval = mRangeAxisInterval(i)
  firstTickRange = Int(mRangeMin * mRangeUnitFromMeters / axisInterval) * axisInterval
  If firstTickRange < mRangeMin * mRangeUnitFromMeters Then _
    firstTickRange = firstTickRange + axisInterval
  
  '  Fill in the range labels array, and determine the max width
  '  required to properly display the labels
  
  Dim tickRange As Single
  Dim factor As Single
  
  tickRange = firstTickRange
  factor = (mNPointsY * mPixelSizeY) / ((mRangeMax - mRangeMin) * mRangeUnitFromMeters)
  
  ReDim mRangeLabels(0 To nDivisions) As LabelType
  
  Dim labelWidth As Long
  Dim maxLabelWidth As Long
  
  maxLabelWidth = 0
  
  For i = 0 To nDivisions
    mRangeLabels(i).coordinate = (tickRange - mRangeMin * mRangeUnitFromMeters) _
                                 * factor + mEchoPaneY0
    If axisInterval < 1 Then
      mRangeLabels(i).label = Format(tickRange, "#0.0")
    Else
      mRangeLabels(i).label = Format(tickRange, "###0")
    End If
    labelWidth = mPicture.textWidth(mRangeLabels(i).label)
    maxLabelWidth = maxl(labelWidth, maxLabelWidth)
    tickRange = firstTickRange + axisInterval * (i + 1)
  Next i

  mEchoPaneX0 = 2
  mEchoPaneX1 = mPicture.ScaleWidth - (mRangeTick + mRangeLabelGap + maxLabelWidth + 4)
   ' 2=1 for axis line + 1 for blank pixel right of label + 2 for focus border

End Sub

Private Sub RangeAxisPaint(Optional ByVal gridOnly As Boolean = False)
  
  mPicture.FontItalic = False
  mPicture.forecolor = mColormap.GetGridColor()

  If mUseRangeLabels Then ' Erase the axis area
    mPicture.Line (mEchoPaneX1, mEchoPaneY0)-(mPicture.ScaleWidth - 2, mPicture.ScaleHeight - 2), _
                  mColormap.GetColor(0), BF
    mPicture.Line (mEchoPaneX1, mEchoPaneY0)-(mEchoPaneX1, mEchoPaneY1), _
                  mColormap.GetGridColor()
  End If
  
  Dim i As Long
  
  For i = 0 To UBound(mRangeLabels)
  
    If mUseRangeGrid Then
    
      ' Draw in the grid
      If mRangeLabels(i).coordinate >= mEchoPaneY0 And _
         mRangeLabels(i).coordinate < mEchoPaneY1 Then
        mPicture.DrawStyle = vbDot
        mPicture.Line (mEchoPaneX0, mRangeLabels(i).coordinate)-(mEchoPaneX1, mRangeLabels(i).coordinate), _
                      mColormap.GetGridColor
        mPicture.DrawStyle = vbSolid
      End If
    End If
    
    If mUseRangeLabels Then
    
      ' Draw in the labels
      
      If mRangeLabels(i).coordinate >= mEchoPaneY0 And _
         mRangeLabels(i).coordinate < mEchoPaneY1 Then
    
        mPicture.Line (mEchoPaneX1 + 1, mRangeLabels(i).coordinate)-Step(mRangeTick, 0), _
                      mColormap.GetGridColor
                            
        Dim delta As Single
        delta = mPicture.TextHeight(mRangeLabels(i).label) / 2
        mPicture.CurrentY = mRangeLabels(i).coordinate - delta
        mPicture.CurrentX = mPicture.CurrentX + mRangeLabelGap
        
        If mPicture.CurrentY >= mEchoPaneY0 And _
           mRangeLabels(i).coordinate + delta <= mEchoPaneY1 Then
           mPicture.Print mRangeLabels(i).label
        End If
      
      End If
    End If
  
  Next i

  mPicture.CurrentX = mPicture.width / Screen.TwipsPerPixelX - 25
  mPicture.CurrentY = mPicture.height / Screen.TwipsPerPixelY - 30
  mPicture.FontItalic = True
  mPicture.Print mRangeUnitAbbrev  'DFL KB#12 KB#171
  
End Sub

Private Sub InsertEcho(echo As EchoClass, ByVal column As Long)

  Dim row As Long
  
  row = RangeToRow(echo.GetRange())
  If row >= 0 And row < mNPointsY Then
  
    If mEchogramType = egtEnergy Then
      If echo.IsBottom() Then
        Debug.Print ("Bottom at " & echo.GetRange())
        mZValues(row, column) = mColormap.GetBottomStrength()
      Else
        mZValues(row, column) = _
          maxd(mZValues(row, column), echo.GetTargetStrength())
      End If
      
    Else ' Classification gram
    
      '  If there is more than one echo in a bin, make them of
      '  type "mixture" unless all echoes are of the same class
    
      If mZValues(row, column) >= classMixture And _
         mZValues(row, column) <> echo.GetClassification() Then
        mZValues(row, column) = classMixture
      Else
        mZValues(row, column) = echo.GetClassification()
      End If
    End If
  End If

End Sub

Private Sub LoadDataFromDatabase()

  Dim C As Integer
  Dim query As String
  Dim r As Integer
  Dim rs As ADODB.Recordset
  
  If mPingMax - mPingMin + 1 > mNPointsX Then
    ' Too many points to display, so drop off the earlier pings
    mPingMin = mPingMax - mNPointsX + 1
  End If
  query = "select * from echo where pingNumber >= " & mPingMin & _
    " and pingNumber <= " & mPingMax & " and range >= " & mRangeMin & _
    " and range <= " & mRangeMax
  Set rs = general.pingDB.RecordSetOpen(query, options:=adCmdText)
  
  mNColumns = mNPointsX
  mNPointsY = mNPointsY
  mFirstColumn = 0
  mFirstRow = 0
  Dim emptyValue As Single
  emptyValue = getEmptyValue()
  For r = 0 To mNPointsY - 1
    For C = 0 To mNColumns - 1
      mZValues(r, C) = emptyValue
    Next C
  Next r
  
  Dim echo As New EchoClass
  
  Do While Not rs.EOF
    echo.ReadFromDB rs
    C = echo.GetPingNumber() - mPingMin
    InsertEcho echo, C
    mPingNumbers(C) = echo.GetPingNumber()
    rs.MoveNext
  Loop
  rs.Close
  
  Dim i As Long
  For i = 0 To mNColumns - 1
    mPingValid(i) = True
  Next i
  
  For i = 1 To mNColumns - 1
    If mPingNumbers(i) < 1 Then mPingNumbers(i) = mPingNumbers(i - 1) + 1
  Next i

End Sub

Private Sub MouseController(ByVal theEvent As MouseEventType, _
                            ByVal Button As Integer, _
                            ByVal Shift As Integer, _
                            ByVal X As Single, _
                            ByVal Y As Single)
                            
  Dim oldDrawMode As Integer
  Dim oldDrawStyle As Integer
  Dim oldFillStyle As Integer
  Dim tmp As Single
  
  On Error GoTo oops
  
  '''mPicture.SetFocus  ' Grab focus when mouse is over us
  
  Select Case mBox.controllerState
    Case 0                  ' Normal resting state
      Select Case theEvent
      
        Case MouseUp
          If (Button And vbRightButton) <> 0 Then
             RaiseEvent ContextMenuRequest(X, Y)
          End If
          
        Case MouseDown
          If (Button And vbLeftButton) <> 0 Then
            ' Start dragging a box
            If mBox.active Then ClearBox
            If general.sonarIF.IsPinging And mEchogramSource = estRealtime Then Exit Sub
            mBox.controllerState = 1
            X = limitL(mEchoPaneX0, X, mEchoPaneX1)
            Y = limitL(mEchoPaneY0, Y, mEchoPaneY1)
            mBox.x0 = X
            mBox.y0 = Y
            mBox.x1 = X
            mBox.y1 = Y
            mBox.active = True
            mBox.color = vbWhite
            oldDrawMode = mPicture.DrawMode
            oldDrawStyle = mPicture.DrawStyle
            oldFillStyle = mPicture.FillStyle
            mPicture.DrawStyle = vbSolid
            mPicture.DrawMode = vbXorPen
            mPicture.FillStyle = vbFSTransparent
            mPicture.Line (X, Y)-(X, Y), mBox.color, B
            mPicture.DrawMode = oldDrawMode
            mPicture.DrawStyle = oldDrawStyle
            mPicture.FillStyle = oldFillStyle
          End If
        
        Case MouseMove
          DisplayGramInfo X, Y
          
        Case Cancel
          If mBox.active Then ClearBox
        
      End Select ' mouseEvent
  
    Case 1                  ' Dragging a box
      Select Case theEvent
        Case MouseUp
          With mBox
            .controllerState = 0
            If .x0 = .x1 Or .y0 = .y1 Or Abs(.x0 - .x1) <= 2 Or Abs(.y0 - .y1) <= 2 Then
              ClearBox
              Exit Sub
            End If
'            mnuClearBox.Enabled = .active
            If .x0 > .x1 Then
              tmp = .x0: .x0 = .x1: .x1 = tmp
            End If
            If .y0 > .y1 Then    ' Ensure 1st point upper left
              tmp = .y0: .y0 = .y1: .y1 = tmp
            End If
          End With
        Case MouseDown
          'Debug.Assert (False)
        Case MouseMove
        
          '  Draw over the old box (restoring original contents) and
          '  draw in the new box.  Update the box corners.
          
          If X < mEchoPaneX0 Then
            X = mEchoPaneX0
          ElseIf X > mEchoPaneX1 Then
            X = mEchoPaneX1
          End If
          If Y < mEchoPaneY0 Then
            Y = mEchoPaneY0
          ElseIf Y > mEchoPaneY1 Then
            Y = mEchoPaneY1
          End If
          DisplayGramInfo X, Y
          oldDrawMode = mPicture.DrawMode
          oldDrawStyle = mPicture.DrawStyle
          oldFillStyle = mPicture.FillStyle
          mPicture.DrawStyle = vbSolid
          mPicture.DrawMode = vbXorPen
          mPicture.FillStyle = vbFSTransparent
          mPicture.Line (mBox.x0, mBox.y0)-(mBox.x1, mBox.y1), mBox.color, B
          mPicture.Line (mBox.x0, mBox.y0)-(X, Y), mBox.color, B
          mPicture.DrawMode = oldDrawMode
          mPicture.DrawStyle = oldDrawStyle
          mPicture.FillStyle = oldFillStyle
          mBox.x1 = X
          mBox.y1 = Y
          
        Case Cancel
          ClearBox
          mBox.controllerState = 0
      End Select ' mouseEvent
  
  End Select ' controllerState
  
  Exit Sub
  
oops:

  ErrorBox boxCaption:="Echogram MouseController Error"

End Sub
Public Sub MenuAction(ByVal action As EchoGramActions)

  '  Called by a menu handling object (probably a form) to effect
  '  the action requested by the menu.

  Select Case action
  
    Case egaClearBox
      ClearBox
      
    Case egaCopy
      CopyToClipboard
      
    Case egaClearGram
      ClearGram
    
    Case egaChangeType
      changeType
    
    Case egaDistribution
      distributionPlot
    
    Case egaExtractEchoes
      ExtractEchoes
      
    Case egaOptions
      FormatGram
      
    Case egaPrint
      GramPrint
      
    Case egaZoom
      Zoom
      
    Case Else
      Debug.Assert False
      
  End Select

End Sub

Private Sub PaintGram()

  Dim column As Integer
  Dim columnNumber As Integer
  Dim X As Integer
  Dim Y As Integer
  
  ' Clear the plot area
  
  mPicture.Line (0, 0)-(mPicture.width, mPicture.height), _
                mColormap.Colorize(getEmptyValue()), BF
 
  ' Plot the gram columns that have valid data

  For columnNumber = 0 To mNColumns - 1
    column = (columnNumber + mFirstColumn) Mod mNPointsX
    X = ColumnToX(column)       ' - REB 2002.08.12 overlap error fix
    PaintGramLine column, X, mEchoPaneY0
  Next columnNumber
    
  TimeAxisPaint
  RangeAxisPaint
  
  '  If tracks are being shown, we need to re-plot them - REB
  
  If showingTracks Then RePlotTracks
  
  '  If a selection box is on the screen, redraw it.
  
  Dim oldDrawMode As Integer
  Dim oldDrawStyle As Integer
  Dim oldFillStyle As Integer
  
  If mBox.active Then
    oldDrawMode = mPicture.DrawMode
    oldDrawStyle = mPicture.DrawStyle
    oldFillStyle = mPicture.FillStyle
    mPicture.DrawStyle = vbSolid
    mPicture.DrawMode = vbXorPen
    mPicture.FillStyle = vbFSTransparent
    mPicture.Line (mBox.x0, mBox.y0)-(mBox.x1, mBox.y1), mBox.color, B
    mPicture.DrawMode = oldDrawMode
    mPicture.DrawStyle = oldDrawStyle
    mPicture.FillStyle = oldFillStyle
  End If
  
  If mHaveFocus Then mPicture_GotFocus
  
End Sub
Private Sub PaintGramLine(ByVal column As Integer, _
                          ByVal X As Integer, ByVal Y As Integer)
                         
  ' Row,Column are a location in the gram data array
  ' X,Y is a point on the display (which may be mapped to multiple pixels
  
  Dim color As Long            ' color of current point
  Dim colorPrevious As Long    ' color of previous point(s)
  Dim dx As Integer            ' holds point x pitch
  Dim dy As Integer            ' holds point y pitch
  Dim i As Long
  Dim j As Long
  Dim nPoints As Integer       ' number of points batched into the draw line
  Dim row As Integer

  '  Process first point
  
  nPoints = 1

  colorPrevious = mColormap.Colorize(mZValues(0, column))

  dx = mPixelSizeX
  dy = mPixelSizeY
  Dim oldFillStyle As Integer
  oldFillStyle = mPicture.FillStyle
  mPicture.FillStyle = vbFSSolid
  
  ' Loop over the rest of the points in the column
  
  For row = 1 To mNPointsY - 1

    color = mColormap.Colorize(mZValues(row, column))

    If color <> colorPrevious Then
    
      '  New color; print previous pixels and set up for this color
      mPicture.FillColor = colorPrevious
      mPicture.Line (X, Y)- _
                       Step(dx - 1, nPoints * dy - 1), _
                       colorPrevious, BF
                       
      Y = Y + nPoints * dy
      nPoints = 1
      colorPrevious = color
    
    Else
    
      '  Same as previous color; batch it up
      
      nPoints = nPoints + 1
      
    End If
  Next row
  
  ' Plot the remaining batch of pixels
  
  mPicture.Line (X, Y)- _
                   Step(dx - 1, nPoints * dy - 1), _
                   colorPrevious, BF
  
  mPicture.FillStyle = oldFillStyle

End Sub

Public Sub PingArrived(ByVal pingNumber As Long)

  Dim echo As EchoClass
  Dim i As Long
  Dim j As Integer
  Dim row As Integer
  Dim theLatitude As Double
  Dim theLongitude As Double
  Dim theTime As Date
  Dim windowSize As Integer
  Dim Y As Double
  Dim y0 As Double
  
  If mEchogramType = egtClass Then
  
    ' For class type plots, check to see if the classifier has changed.
    ' If it has, resize the arrays.
  
    If mClassifier Is Nothing And general.sonarIF.GetClassifier Is Nothing Then
      Exit Sub ' No classifier, so cannot do much of anything.
    ElseIf Not mClassifier Is general.sonarIF.GetClassifier Then
    
      Set mClassifier = general.sonarIF.GetClassifier
      Dim colormap As ColorMapClass
      Set colormap = New ColorMapClass
      On Error GoTo skipIt
      colormap.ReadFromDB mClassifier.GetColorMapName
      Set mColormap = colormap
      LayoutGram
skipIt:
    End If
  
  End If
  
  If mColormap.GetClassifier Is Nothing And _
     Not general.sonarIF.GetClassifier Is Nothing And _
     mColormap.GetType = cmCategory Then
    mColormap.SetClassifier general.sonarIF.GetClassifier
  End If

  If IsEmpty(mRangeMax) Then
    mRangeMax = general.sonarIF.GetMaxRange()
    SetRangeFactor
  End If
  
  If mNPointsX = 0 Then mNPointsX = 1 'DFL
  
  mCurrentColumn = (mCurrentColumn + 1) Mod mNPointsX
  mPingNumbers(mCurrentColumn) = pingNumber
  theTime = general.sonarIF.GetPingTime()
  mPingTimes(mCurrentColumn) = theTime
  theLatitude = general.sonarIF.GetPingLatitude()
  mPingLatitudes(mCurrentColumn) = theLatitude
  theLongitude = general.sonarIF.GetPingLongitude()
  mPingLongitudes(mCurrentColumn) = theLongitude
  
  '   Make the gram data column have -inf values

  Dim emptyValue As Single
  emptyValue = getEmptyValue()
  For row = 0 To mNPointsY - 1
    mZValues(row, mCurrentColumn) = emptyValue
  Next row
  
  '  Go through the echoes and install them into the appropriate
  '  point on the gram.  Each point will hold the maximum target
  '  strength of all echoes associated with the point
  
  nEchoes = general.sonarIF.GetNEchoes()
  
  For i = 0 To nEchoes - 1
    Set echo = general.sonarIF.GetEcho(i)
    InsertEcho echo, mCurrentColumn
  Next i
  
  '   Update the screen
  
  mNColumns = mNColumns + 1
  If mNColumns >= mNPointsX Then
  
    If mScrollOneColumn Then
    
      mNColumns = mNColumns - 1
      mFirstColumn = (mFirstColumn + 1) Mod mNPointsX
    
    Else
  
      ' If we've filled up the gram, then shift the right quarter to
      ' the first quarter (making the rest of the data empty) and
      ' repaint the entire gram
    
      mNColumns = mNPointsX * 9 / 10
      mFirstColumn = (mFirstColumn + mNPointsX - mNColumns) Mod mNPointsX
    End If
    
    PaintGram
    
  Else

    ' There's room on the screen so paint the column we just added
  
    PaintGramLine mCurrentColumn, ColumnToX(mCurrentColumn), _
                  mEchoPaneY0
    TimeAxisPaintPoint theTime, ColumnToX(mCurrentColumn), _
      mPreviousMinute, mLeftMargin, theLatitude, theLongitude
    RangeAxisPaint True
    
    ' Draw tracks for column if showing tracks for this echogram...
    If showingTracks Then DisplayTracks (mCurrentColumn) 'REB 2002.08.06 - let's draw some tracks

  End If
  
  '  If we notice a ping number discrepancy, then mark all the
  '  pings except this one as invalid.
  
  If mNColumns > 1 Then
    If mPingNumbers(mCurrentColumn) <= _
       mPingNumbers(Modulus(mCurrentColumn - 1, mNPointsX)) Then
       For i = 0 To mNPointsX - 1
         mPingValid(i) = False
       Next i
    End If
  End If
  mPingValid(mCurrentColumn) = True

End Sub
Private Function RangeToRow(ByVal range As Single) As Long

  Dim row As Long
  
  RangeToRow = Int((range - mRangeMin) * mRangeFactor)

End Function
Private Function RowToRange(row As Long) As Single

  RowToRange = row / mRangeFactor + mRangeMin

End Function
Private Sub SetRangeFactor()

  '  All three of the values NPointsY, rangeMax and rangeMin
  '  must be at their correct values before calling this routine

  mRangeFactor = mNPointsY / (mRangeMax - mRangeMin)

End Sub
Public Sub SetupEchoGram(ByVal prefix As String, _
                         ByVal gramSource As EchogramSourceType, _
                         ByVal gramType As EchogramType, _
                         ByVal name As String, _
                         picture As PictureBox, _
                         Optional ByVal pixelSizeX As Variant, _
                         Optional ByVal pixelSizeY As Variant, _
                         Optional ByVal rangeMin As Variant, _
                         Optional ByVal rangeMax As Variant, _
                         Optional ByVal pingMin As Variant, _
                         Optional ByVal pingMax As Variant, _
                         Optional ByVal colormap As Variant, _
                         Optional ByVal scrollOneColumn As Boolean = False)
                     
  mPrefix = prefix    ' - REB 2002.08.16
  mName = name
  mPropertyPrefix = prefix
  Set mPicture = picture
  mPicture.AutoRedraw = True
  mPicture.ScaleMode = vbPixels
  mEchogramSource = gramSource
  mEchogramType = gramType
  
  With general.propertyList
    mCursorInfoDisplay = .GetProperty(prefix & ":CursorInfoDisplay", True)
    mStatusBarDisplay = .GetProperty(prefix & ":StatusBarDisplay", True)
    mUseLatLon = .GetProperty(prefix & ":Uselatlon", True)
    mUseRangeGrid = .GetProperty(prefix & ":UseRangeGrid", True)
    mUseRangeLabels = .GetProperty(prefix & ":UseRangeLabels", True)
    mUseTimeGrid = .GetProperty(prefix & ":UseTimeGrid", True)
    mUseTimeLabels = .GetProperty(prefix & ":UseTimeLabels", True)
    mPixelSizeX = GetValue(pixelSizeX, prefix & ":PixelSizeX", 2)
    mPixelSizeY = GetValue(pixelSizeY, prefix & ":PixelSizeY", 2)
    mRangeMin = GetValue(rangeMin, prefix & ":RangeMin", 0)
    mRangeMax = GetValue(rangeMax, prefix & ":RangeMax", mRangeMin + 10)
    If mRangeMax <= mRangeMin Then mRangeMax = mRangeMin + 10
    mRangeUnit = .GetProperty("General:RangeUnits", ruMeters)
    ConfigureRangeUnits mRangeUnit
    
    '  Get a colormap
    
    If Not IsMissing(colormap) Then
      Set mColormap = colormap
    Else
    
      ' None was provided, so hunt one up.
    
      Set mColormap = New ColorMapClass
      Dim mapName As String
      If mEchogramType = egtClass Then
        If general.sonarIF.GetClassifier() Is Nothing Then
          mapName = "_StandardClass"
        Else
          Set mClassifier = general.sonarIF.GetClassifier()
          mapName = mClassifier.GetColorMapName()
          If mapName = "" Then mapName = "_StandardClass"
        End If
        On Error GoTo mapReadFailed
        mColormap.ReadFromDB mapName
mapReadFailed:
        On Error GoTo 0
      Else
        mapName = general.propertyList.GetProperty(prefix & ":ColorMapName", "_StandardEnergy")
        If mapName <> "" Then
          On Error Resume Next
          mColormap.ReadFromDB mapName
          On Error GoTo 0
        End If
      End If
    End If
    mScrollOneColumn = scrollOneColumn
  End With
  
  If mEchogramSource = estDatabase Then
    Debug.Assert (Not IsMissing(pingMin) And Not IsMissing(pingMax))
    mPingMin = pingMin
    mPingMax = pingMax
  Else
    general.sonarIF.addPingListener Me, sonarDataEchoes
  End If

End Sub

Public Sub ExtractEchoes()

  Dim column As Long
  Dim pingMax As Long
  Dim pingMin As Long
  Dim rangeMax As Single
  Dim rangeMin As Single
  Dim row As Long

  If mBox.active Then
    ConvertFromPixelBox mBox, pingMin, pingMax, rangeMin, rangeMax
    Load frmEchoExtractor
    frmEchoExtractor.SetupRanges pingMin, pingMax, rangeMin, rangeMax
  End If
  frmEchoExtractor.Adodc1.connectionString = general.pingDB.GetSource()
  frmEchoExtractor.Show 1

End Sub
Public Sub TeardownGram()

  general.sonarIF.removePingListener Me
  Set mPicture = Nothing

End Sub
Private Sub TimeAxisPaint()

  Dim i As Long
  Dim j As Long
  Dim label As String
  Dim labelWidth As Single
  Dim theTime As Date
  Dim tickX As Single
  Dim timeTickWidth As Long
  
  mPicture.forecolor = mColormap.GetGridColor()
  mPicture.Line (mEchoPaneX0, mEchoPaneY1)-(mEchoPaneX1, mPicture.height), mColormap.GetColor(0), BF
  mLeftMargin = mEchoPaneX0
  mPreviousMinute = -1
  mPreviousPositionEnd = mEchoPaneX0
  For i = 0 To mNColumns - 1
    j = (i + mFirstColumn) Mod mNPointsX ' translate column number to column index
    theTime = mPingTimes(j)
    TimeAxisPaintPoint mPingTimes(j), i * mPixelSizeX, mPreviousMinute, mLeftMargin, _
                       mPingLatitudes(j), mPingLongitudes(j)
  Next i
  mPicture.Line (mEchoPaneX0, mEchoPaneY1 + 1)-(mEchoPaneX1, mEchoPaneY1 + 1), mColormap.GetGridColor()
  
End Sub

Private Sub TimeAxisPaintPoint(ByVal theTime As Date, X As Long, _
                              ByRef previousMinute As Integer, _
                              leftMargin As Long, ByVal theLatitude As Double, _
                              ByVal theLongitude As Double)
                              
  Dim label As String
  Dim labelWidth As Single
  Dim timeTickWidth As Long
  
  If Minute(theTime) <> previousMinute Then
    previousMinute = Minute(theTime)
    label = Format(theTime, "h:Nn")
    labelWidth = mPicture.textWidth(label)
    If X - labelWidth / 2 >= leftMargin Then
      If X + labelWidth / 2 < mPicture.ScaleWidth - 1 Then
      
        Dim gridStyle As Integer
        gridStyle = vbDot
      
        '  Now see if we can do the position
        
        If mUseLatLon Then
          Dim leftLabel As String
          Dim rightLabel As String
          Dim llLabel As String
          leftLabel = LatLonDoubleToString(theLatitude, True)
          rightLabel = LatLonDoubleToString(theLongitude, False)
          llLabel = leftLabel & " " & rightLabel
          If X > mPreviousPositionEnd And _
             X + mPicture.textWidth(llLabel) + 2 < mEchoPaneX1 Then
            mPicture.CurrentX = X + 2
            mPicture.CurrentY = 2
            mPicture.Print llLabel
            mPreviousPositionEnd = X + mPicture.textWidth(llLabel) + 6
            mPicture.Line (X, mEchoPaneY0)-(X, 2)
            gridStyle = vbSolid
          End If
        End If
        
        '  Draw in the time grid lines
        
        If mUseTimeGrid Then
          mPicture.DrawStyle = gridStyle
          mPicture.Line (X, mEchoPaneY0)-(X, mEchoPaneY1 - 1), _
                           mColormap.GetGridColor
          mPicture.DrawStyle = vbSolid
          leftMargin = X + mPicture.textWidth("XX:XX") / 2 + 4 ' pixels
        End If
        
        '  Draw in the time labels
        
        If mUseTimeLabels Then
          mPicture.Line (X, mEchoPaneY1)-Step(0, mTimeTick), mColormap.GetGridColor
          mPicture.CurrentX = mPicture.CurrentX - labelWidth / 2
          mPicture.CurrentY = mPicture.CurrentY + mTimeLabelGap 'pixels
          mPicture.Print label
        End If
      End If
      
      
      
    End If
  End If

End Sub

Public Sub Zoom()

  Debug.Assert (mBox.active)
  
  Dim column0 As Long
  Dim column1 As Long
  Dim nPointsX As Long
  Dim nPointsY As Long
  Dim ping0 As Long
  Dim ping1 As Long
  Dim range0 As Single
  Dim range1 As Single
  Dim row0 As Long
  Dim row1 As Long
  
  Dim containsInvalidEchoes As Boolean ' REB 2002.08.19
  Dim showTracksInZoom As Boolean
  
  '  The the coordinates of the box
  
  containsInvalidEchoes = ConvertFromPixelBox(mBox, ping0, ping1, range0, range1)
  nPointsX = ping1 - ping0 + 1
  nPointsY = (mBox.y1 - mBox.y0 + 1)
  
  Dim zoomGram As frmEchogram2
  Set zoomGram = New frmEchogram2

  showTracksInZoom = (Not containsInvalidEchoes) And showTracksInZoom

  zoomGram.Left = (mBox.x1 + mPicture.Left) * Screen.TwipsPerPixelX + mPicture.parent.Left + 108
  zoomGram.width = nPointsX * mPixelSizeX * 2 * Screen.TwipsPerPixelX + 720
  zoomGram.height = nPointsY * mPixelSizeY * 2 * Screen.TwipsPerPixelY + 720
  zoomGram.ShowEchogram "Zoom", mEchogramType, estDatabase, "Zoom Echogram", nPointsX:=nPointsX, nPointsY:=nPointsY, _
    rangeMin:=range0, rangeMax:=range1, colormap:=mColormap, _
    pingMin:=ping0, pingMax:=ping1, pixelSizeX:=mPixelSizeX * 2, pixelSizeY:=mPixelSizeY * 2, _
    showingTracks:=showTracksInZoom
 
End Sub

Private Sub mPicture_GotFocus()

  mPicture.DrawWidth = 2
  mPicture.Line (1, 1)-(mPicture.ScaleWidth - 1, mPicture.ScaleHeight - 1), _
                mFocusColor, B
  mPicture.DrawWidth = 1
  mHaveFocus = True

End Sub

Private Sub mPicture_KeyDown(KeyCode As Integer, Shift As Integer)

  Dim altbutton As Boolean
  Dim controlbutton As Boolean
  Dim keyHandled As Boolean
  Dim shiftbutton As Boolean

  shiftbutton = (Shift And vbShiftMask) <> 0
  controlbutton = (Shift And vbCtrlMask) <> 0
  altbutton = (Shift And vbAltMask) <> 0
  
  keyHandled = False
  
  Select Case KeyCode
  
    Case 93 ' Menu key
      RaiseEvent ContextMenuRequest(mPicture.width / 2, mPicture.height / 2)
      keyHandled = True
  
    Case vbKeyF1
      If controlbutton Then
        Dim magicKeys As MagicKeyDisplayClass
        Set magicKeys = New MagicKeyDisplayClass
        
        With magicKeys
          .addKey vbKeyP, "cs", "Ping once"
          .addKey vbKeyDown, "c", "Increase Colormap base level"
          .addKey vbKeyDown, "cs", "Increase Colormap spacing"
          .addKey vbKeyUp, "c", "Decrease Colormap base level"
          .addKey vbKeyUp, "cs", "Decrease Colormap spacing"
          .addKey vbKeyHome, "c", "Restore original mColormap settings"
          .display "Magic Keys for " & mName
        End With
        Set magicKeys = Nothing
      End If
      
    Case vbKeyDown ' Down arrow
    
      If controlbutton Then    ' Adjust color map
        If shiftbutton Then
          mColormap.IncrementIncrement -1
        Else
          mColormap.IncrementOffset -1
        End If
        RaiseEvent StatusBar("map={" & mColormap.GetDynamicOffset & "," & mColormap.GetDynamicIncrement() & "}")
        PaintGram
        keyHandled = True
      End If
    
    Case vbKeyHome
      If controlbutton Then ' adjust mColormap back to original settings
        mColormap.IncrementReset
        RaiseEvent StatusBar("map={original}")
        keyHandled = True
        PaintGram
      End If
          
    Case vbKeyUp ' Up arrow
      If controlbutton Then     ' Adjust mColormap
        If shiftbutton Then
          mColormap.IncrementIncrement 1
        Else
          mColormap.IncrementOffset 1
        End If
        RaiseEvent StatusBar("map={" & mColormap.GetDynamicOffset & "," & mColormap.GetDynamicIncrement() & "}")
        PaintGram
        keyHandled = True
      End If
  
  End Select

  If Not keyHandled Then RaiseEvent KeyDown(KeyCode, Shift)

End Sub

Private Sub mPicture_LostFocus()
  
  mPicture.DrawWidth = 2
  mPicture.Line (1, 1)-(mPicture.ScaleWidth - 1, mPicture.ScaleHeight - 1), _
                mColormap.GetColor(0), B
  mPicture.DrawWidth = 1
  mHaveFocus = False

End Sub

Private Sub mPicture_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseDown, Button, Shift, X, Y

End Sub

Private Sub mPicture_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseMove, Button, Shift, X, Y

End Sub
Private Sub mPicture_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

  MouseController MouseUp, Button, Shift, X, Y

End Sub

Private Sub mPicture_Paint()

  PaintGram

End Sub

Private Sub Class_Initialize()

  mUseLatLon = True
  
  mNColumns = 0
  mPixelSizeX = 2
  mPixelSizeY = 2

  mRangeAxisInterval(0) = 0.5
  mRangeAxisInterval(1) = 1
  mRangeAxisInterval(2) = 2
  mRangeAxisInterval(3) = 5
  mRangeAxisInterval(4) = 10
  mRangeAxisInterval(5) = 20
  mRangeAxisInterval(6) = 50
  mRangeAxisInterval(7) = 100
  mRangeAxisInterval(8) = 200
  
  mOldPictureHeight = 0
  mOldPictureWidth = 0
  
  mRangeTick = rangeTick0 / Screen.TwipsPerPixelX
  mRangeLabelGap = rangeLabelGap0 / Screen.TwipsPerPixelX
  mTimeTick = timeTick0 / Screen.TwipsPerPixelY
  mTimeLabelGap = timeLabelGap0 / Screen.TwipsPerPixelY
  mFocusColor = vbYellow
  mHaveFocus = False
  
  Set mMenu = New Scripting.Dictionary
  mMenu.CompareMode = TextCompare
  
  AddMenuItem "&Options", egaOptions
  AddMenuItem "&Copy To Clipboard", egaCopy
  AddMenuItem "&Print", egaPrint
  AddMenuItem "-", egaSpace1
  AddMenuItem "&Distribution", egaDistribution
  AddMenuItem "&ExtractEchoes", egaExtractEchoes
  AddMenuItem "&Zoom", egaZoom
  AddMenuItem "-", egaSpace2
  AddMenuItem "&Clear Box", egaClearBox
  AddMenuItem "-", egaSpace3
  AddMenuItem "Clear Gram", egaClearGram
  AddMenuItem "Change Type", egaChangeType

  ConfigureRangeUnits ruMeters

End Sub

Private Sub Class_Terminate()

  If mEchogramSource = estRealtime Then general.sonarIF.removePingListener Me

End Sub

Private Sub DisplayTracks(childColumn As Long)

  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' This method is responsible for displaying (new) tracks on the echogram display
  ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  On Error GoTo oops:
  
  Dim rtv As Variant
  
  Dim childPing As Long    ' the ping being dealt with
  Dim parentPing As Long   ' the childPing's parent
  Dim numOfEchoes As Integer  ' number of echoes in a ping
  Dim echoIndex As Long    ' index for echoes - also echo number in the child ping
  Dim parentEcho As Long   ' echo number of the "parent" echo in the previous ("parent") ping
  Dim rangeChild As Double    ' range of the current ("child") echo in the current ("child") ping.
  Dim rangeParent As Double   ' range of the "parent" echo in the previous ("parent") ping
  Dim trackNum As Integer     ' track number of the track being drawn - needed for coloring
  
  ' get child and parent pings and make sure that there is enough data to draw tracks
  If mPingNumbers(mCurrentColumn) < 1 Then Exit Sub  ' Need more than a single ping to draw tracks.
  If childColumn < 1 Then Exit Sub  ' can't connect the first "zero-th" pings echoes to pred.
  
  childPing = mPingNumbers(childColumn)
  If mPingNumbers(childColumn - 1) <> (childPing - 1) Then Exit Sub
    
  numOfEchoes = general.sonarIF.Tracker_NumEchoesInPing(childPing)  ' get the # of echoes (= number of tracks) in the "child ping"
   
  For echoIndex = 0 To (numOfEchoes - 1) ' echoes are zero based so "0 to (#### - 1)"
      
    ' find the associated echo in the parent ping.
    rtv = general.sonarIF.Tracker_getParentEcho((childPing), (echoIndex), parentPing, parentEcho)
    
    ' NO_PARENT (-1002) indicates that there is no parent
    If parentEcho <> NO_PARENT And rtv <> NO_PARENT Then
        ' get the ranges of both pings
      rangeChild = general.sonarIF.Tracker_getEchoRange(childPing, echoIndex)
      rangeParent = general.sonarIF.Tracker_getEchoRange(parentPing, parentEcho)
      
        ' Check ranges:  If both echoes are visible then call the drawing method
      If (IsBetween(rangeChild, mRangeMin, mRangeMax) And _
                    IsBetween(rangeParent, mRangeMin, mRangeMax)) _
                    Then DrawTrack childColumn, childPing, rangeChild, _
                    parentPing, rangeParent

      Else
          ' Since there is no parent, this echo is the starting point of the track.
      End If
    
  Next echoIndex
  
  Exit Sub

oops:
  StoreError
  mShowTracks = False
  
End Sub

Private Function showingTracks() As Boolean
  
  On Error GoTo oops:
  
  showingTracks = mShowTracks And IsTracking

  Exit Function
oops:
  StoreError
  showingTracks = False
  
End Function

Public Sub Set_mShowTracks(value As Boolean)
  
  mShowTracks = value
  
End Sub

Private Sub DrawTrack(childColumn As Long, childPing As Long, _
          rangeChild As Double, parentPing As Long, rangeParent As Double)

  ' This sub will do the actual drawing of the tracks on the echogram...
  On Error GoTo oops:
  
  If childColumn < 1 Then Exit Sub ' the parent needs to be visible and on the left..
  
  Dim parentX As Integer
  Dim childX As Integer
  Dim parentY As Integer
  Dim childY As Integer
  Dim lineColor As Long
  
  Dim index As Integer
  Dim topOffset As Integer, bottomOffset As Integer
  
  Dim dx As Integer
  Dim dy As Integer
  
  ' center the start and end in of track line in an echo-point.
  dx = (mPixelSizeX - 1) / 2
  dy = (mPixelSizeY - 1) / 2
  
  ' assign the track's color
  lineColor = vbBlue
  
  ' Convert ranges and ping numbers into coordinates that can be used for drawing...
  parentX = ColumnToX(childColumn - 1) + dx
  childX = ColumnToX(childColumn) + dx
  
  ' check to see if still part of ping series - needed???
  If parentX > childX Then Exit Sub
  
  parentY = RangeToRow(rangeParent) * mPixelSizeY + mEchoPaneY0 + dy
  childY = RangeToRow(rangeChild) * mPixelSizeY + mEchoPaneY0 + dy
  
  mPicture.Line (parentX, parentY)-(childX, childY), lineColor
  
  Exit Sub
  
oops:
  StoreError
  mShowTracks = False
  
End Sub

Public Function RePlotTracks()
    
  On Error GoTo oops:
  
  Dim columnNumber As Integer
  Dim column As Integer
  
  Dim parent As Integer
  Dim child As Integer
    
  parent = mPingNumbers((mNColumns - 1 + mFirstColumn + mNPointsX) Mod mNPointsX) + 1
  child = parent + 1
  
  ' Needed in case plotting in zoomed gram...
  If mCurrentColumn = -1 Then mCurrentColumn = mNPointsX - 1    ' This works i all of the points are new
    
  For columnNumber = mNColumns - 1 To 1 Step -1
    If (parent + 1) <> child Then Exit For
    column = (columnNumber + mFirstColumn) Mod mNPointsX
    DisplayTracks (column)            '  REB 2002.08.06 - let's draw some tracks
    child = parent
    parent = mPingNumbers(column)
  Next columnNumber
  
  Exit Function
oops:
  StoreError

End Function

Private Function IsTracking() As Boolean

  On Error GoTo oops:
  
  IsTracking = general.sonarIF.trx.IsTracking
  
  Exit Function
  
oops:
  StoreError
  IsTracking = False
  
End Function

Public Function CheckPixelSizeAtStart() As Variant

  On Error GoTo oops:
  
  CheckPixelSizeAtStart = ""
  
  If mPixelSizeX < 3 Then _
    CheckPixelSizeAtStart = "Horizontal echo size is " & mPixelSizeX & _
                            ", but should be at least 3 pixels in size" & vbCrLf
  
  If mPixelSizeY < 3 Then CheckPixelSizeAtStart = CheckPixelSizeAtStart & _
                    "Vertical echo size is " & mPixelSizeY & _
                    ", but should be at least 3 pixels in size" & vbCrLf
    
  If Not IsTracking Or Not mShowTracks Then CheckPixelSizeAtStart = ""
  
  Exit Function
  
oops:
  StoreError
  CheckPixelSizeAtStart = "Horizontal echo size should be larger than 2 pixels" & vbCrLf
  CheckPixelSizeAtStart = CheckPixelSizeAtStart & _
                    "Vertical echo size should be larger than 2 pixels" & vbCrLf
                    
End Function
  
Public Sub SetMinEchoSize(minX As Long, minY As Long)

  On Error GoTo oops:
  If Not showingTracks Then Exit Sub
  
  If minX > mPixelSizeX Then mPixelSizeX = minX
  If minY > mPixelSizeY Then mPixelSizeY = minY
  
  With general.propertyList
    .SetProperty mPropertyPrefix & ":pixelSizeX", mPixelSizeX
    .SetProperty mPropertyPrefix & ":pixelSizeY", mPixelSizeY
    ConfigureRangeUnits mRangeUnit
  End With
    
  LayoutGram
  
  Exit Sub
  
oops:
  StoreError
  
End Sub
